require( "scripts/style.lua" );

SetPauseMenuCanShow(false);
SetConfirmExitCanShow(true);

--[[
TitleFont = {
  standardFont,
  70,
  BlackColor
};
--]]


MakeDialog
{
    -- Name the modal dialog
    name="creditswindow",
    Bitmap
    {
        image="ui/surfaces/fullscreendialog",

        SetStyle(CreateTextStyle(FontGame, 70, BlackColor)),
        Text
        {
            x=kCenter,y=60,
            flags = kHAlignCenter + kVAlignTop,
            label = "credits"
        };

        CreditsWindow
        {
            x = 0, y = 150,
            w = 800, h = 386,
            font = FontGame,
            fontsize = 16,
            fontcolor = BlackColor,
            headercolor = DarkBlueColor,
            columngap = 50,
            columnwidth = 325,
            time = 20000, 		-- Time to play credits in milliseconds
            intropause = 3000, 	-- Time to pause credits at start, in ms
            file = "credits/credits.txt",
        },

        SetStyle(CreateTextStyle(FontGame, 14, BlackColor)),
        Text
        {
            flags=kHAlignCenter + kVAlignTop,
            x=0,y=-22,
            label="#"..GetString("version",GetConfig(kGameVersion)) ;
        };
        
        SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
        Button
        {
            x=kCenter + 300,
            y=kMax-60,
            command =
                function()
                    PopModal("creditswindow");
                end,
		    SetStyle(CreateTextStyle(FontButtons, 26, WhiteColorAlpha128)),
		    CreateText(2,2,"back", 0, 0),
		    SetStyle(CreateTextStyle(FontButtons, 26, BlackColor)),
		    CreateText(0,0,"back", 0, 0),
        };
    },
}